%ranks the training set using selected features

TEST_DATA = COMPLETE_DATA(:, find(FINAL_FEATURES));
AVG_CLASS = mean(TEST_DATA(LABELS==TARGET_GROUP,:),1);
TEST_DATA = [TEST_DATA ; AVG_CLASS]; %attach reference vector
all_dists = dist(TEST_DATA'); %compute distances
distances_euclidean = all_dists(:,size(all_dists,1)); %keep only the ones with the reference
%pearson distance
all_dists_2 = corr(TEST_DATA');
distances_pearson = all_dists_2(:,size(all_dists_2,1));
%remove reference vector
distances_euclidean = distances_euclidean(1:end-1);
distances_pearson = distances_pearson(1:end-1);
TEST_DATA(size(TEST_DATA,1),:) = [];

%print euclidean
fprintf('\nEuclidean Distance\n')
[res_sort ix]=sort(distances_euclidean,'ascend');
for i=1:numel(distances_euclidean)
    fprintf(1,'%s: %f [%d]\n', NAMES{ix(i)}, res_sort(i), LABELS(ix(i)));
end


%print pearson
fprintf('\n\nPearson Coefficent\n')
[res_sort ix]=sort(distances_pearson,'descend');
for i=1:numel(distances_pearson)
    fprintf(1,'%s: %f [%d]\n', NAMES{ix(i)}, res_sort(i), LABELS(ix(i)));
end